<?php
  // Create menu
  $title = __('Global', 'all_in_one');
  ais_menu($title);



  // GET & UPDATE PARAMETERS
  // $variable = ais_param_update( 'param_name', 'form_name', 'input_type', 'plugin_var_name' );
  // input_type: check, code or value
  $use_default = ais_param_update( 'use_default', 'plugin_action', 'check', 'plugin-ais' );
  $title_delimiter = ais_param_update( 'title_delimiter', 'plugin_action', 'value', 'plugin-ais' );
  $description_delimiter = ais_param_update( 'description_delimiter', 'plugin_action', 'value', 'plugin-ais' );
  $disable_keywords = ais_param_update( 'disable_keywords', 'plugin_action', 'check', 'plugin-ais' );
  $title_extra = ais_param_update( 'title_extra', 'plugin_action', 'check', 'plugin-ais' );
  $title_multilang = ais_param_update( 'title_multilang', 'plugin_action', 'check', 'plugin-ais' );

  $locale = '-' . ais_get_locale();
  $home_title = ais_param_update( 'home_title' . $locale, 'plugin_action_home', 'value', 'plugin-ais' );
  $home_meta_title = ais_param_update( 'home_meta_title' . $locale, 'plugin_action_home', 'value', 'plugin-ais' );
  $home_meta_description = ais_param_update( 'home_meta_description' . $locale, 'plugin_action_home', 'value', 'plugin-ais' );



  if(Params::getParam('plugin_action') == 'done') {
    message_ok(__('Global settings successfully saved.', 'all_in_one'));
  }

  if(Params::getParam('plugin_action_home') == 'done') {
    message_ok(__('Home page tags successfully saved', 'all_in_one') . ' (' . ais_get_locale() . ')');
  }

?>


<div class="mb-body">

  <!-- GLOBAL SETTINGS -->
  <form name="promo_form" id="promo_form" action="<?php echo osc_admin_base_url(true); ?>" method="POST" enctype="multipart/form-data" >
    <input type="hidden" name="page" value="plugins" />
    <input type="hidden" name="action" value="renderplugin" />
    <input type="hidden" name="file" value="<?php echo osc_plugin_folder(__FILE__); ?>global.php" />
    <input type="hidden" name="plugin_action" value="done" />
    
    <div class="mb-box">
      <div class="mb-head"><i class="fa fa-cog"></i> <?php _e('Global settings', 'all_in_one'); ?></div>

      <div class="mb-inside">
        <div class="mb-row">
          <label for="title_delimiter" class="h3"><span><?php _e('Delimiter of Elements in Title', 'all_in_one'); ?></span></label> 
          <input size="6" name="title_delimiter" id="title_delimiter" type="text" value="<?php echo $title_delimiter; ?>" />
          
          <div class="mb-explain"><?php _e('Character used to delimit elements in title and meta title. Do not enter white spaces.', 'all_in_one'); ?></div>
        </div>


        <div class="mb-row">
          <label for="description_delimiter" class="h3"><span><?php _e('Delimiter of Elements in Description', 'all_in_one'); ?></span></label> 
          <input size="6" name="description_delimiter" id="description_delimiter" type="text" value="<?php echo $description_delimiter; ?>" />
          
          <div class="mb-explain"><?php _e('Characters used to delimit elements in meta description. Do not enter white spaces.', 'all_in_one'); ?></div>
        </div>

        <div class="mb-row">
          <label for="disable_keywords" class="h5"><span><?php _e('Disable Keywords', 'all_in_one'); ?></span></label> 
          <input name="disable_keywords" id="disable_keywords" class="element-slide" type="checkbox" <?php echo ($disable_keywords == 1 ? 'checked' : ''); ?> />

          <div class="mb-explain"><?php _e('Disable meta keywords globaly on all pages.', 'all_in_one'); ?></div>
        </div>

        <div class="mb-row">
          <label for="use_default" class="h6"><span><?php _e('Use Default Tags if Empty', 'all_in_one'); ?></span></label> 
          <input name="use_default" id="use_default" class="element-slide" type="checkbox" <?php echo ($use_default == 1 ? 'checked' : ''); ?> />

          <div class="mb-explain"><?php _e('Use default title, meta title and meta description tags if one generated by plugin are empty.', 'all_in_one'); ?></div>
        </div>

        <div class="mb-row">
          <label for="title_extra" class="h7"><span><?php _e('Page Title Different to Meta Title', 'all_in_one'); ?></span></label> 
          <input name="title_extra" id="title_extra" class="element-slide" type="checkbox" <?php echo ($title_extra == 1 ? 'checked' : ''); ?> />

          <div class="mb-explain"><?php _e('When enabled, it will be possible to set different parameters for Title and Meta Title.', 'all_in_one'); ?></div>
        </div>

        <div class="mb-row">
          <label for="title_multilang" class="h8"><span><?php _e('Improve Meta Title for Multi-Language Site', 'all_in_one'); ?></span></label> 
          <input name="title_multilang" id="title_multilang" class="element-slide" type="checkbox" <?php echo ($title_multilang == 1 ? 'checked' : ''); ?> />

          <div class="mb-explain"><?php _e('If there are 2 or more active languages, language name will be added to Meta Title.', 'all_in_one'); ?></div>
        </div>
      </div>

      <div class="mb-foot">
        <button type="submit" class="mb-button"><?php _e('Update', 'all_in_one');?></button>
      </div>
    </div>
  </form>



  <!-- HOME PAGE SETTINGS -->
  <form name="promo_form" id="promo_form" action="<?php echo osc_admin_base_url(true); ?>" method="POST" enctype="multipart/form-data" >
    <input type="hidden" name="page" value="plugins" />
    <input type="hidden" name="action" value="renderplugin" />
    <input type="hidden" name="file" value="<?php echo osc_plugin_folder(__FILE__); ?>global.php" />
    <input type="hidden" name="plugin_action_home" value="done" />
    
    <div class="mb-box">
      <div class="mb-head"><i class="fa fa-home"></i> <?php _e('Home page settings', 'all_in_one'); ?> <?php echo ais_locale_box( 'global.php' ); ?></div>

      <div class="mb-inside">
        <div class="mb-row">
          <label for="home_title<?php echo $locale; ?>" class="h4"><span><?php _e('Home Page Title', 'all_in_one'); ?></span></label> 
          <input size="80" name="home_title<?php echo $locale; ?>" id="home_title<?php echo $locale; ?>" type="text" value="<?php echo $home_title; ?>" />
        </div>

        <div class="mb-row">
          <label for="home_meta_title<?php echo $locale; ?>" class="h4"><span><?php _e('Home Page Meta Title', 'all_in_one'); ?></span></label> 
          <input size="80" name="home_meta_title<?php echo $locale; ?>" id="home_meta_title<?php echo $locale; ?>" type="text" value="<?php echo $home_meta_title; ?>" />
        </div>

        <div class="mb-row">
          <label for="home_meta_description<?php echo $locale; ?>" class="h4"><span><?php _e('Home Page Meta Description', 'all_in_one'); ?></span></label> 
          <textarea name="home_meta_description<?php echo $locale; ?>" id="home_meta_description<?php echo $locale; ?>" class="mb-textarea-medium"><?php echo $home_meta_description; ?></textarea>
        </div>

      </div>

      <div class="mb-foot">
        <?php if(!ais_is_demo()) { ?>
          <button type="submit" class="mb-button"><?php _e('Update', 'all_in_one');?></button>

        <?php } else { ?>
          <a href="#" onclick="return false" class="mb-button"><?php _e('Save (demo - disabled)', 'all_in_one');?></button>

        <?php } ?>
      </div>
    </div>
  </form>




  <!-- META SNIPPET PREVIEW -->
  <div class="mb-box" id="mb-help">
    <div class="mb-head"><i class="fa fa-tv"></i> <?php _e('Snippet preview - shows how home page will look in google search result', 'all_in_one'); ?></div>

    <?php 
      $snippet_title = osc_highlight($home_meta_title, 60); 
      $snippet_url = osc_base_url();
      $snippet_description = osc_highlight($home_meta_description, 160); 
    ?>

    <div class="mb-inside">
      <div class="mb-row mb-snippet-preview mb-snippet-fake">
        <div class="mb-row mb-snippet-title"><?php _e('SomeWeb.com - Welcome', 'all_in_one'); ?></div>
        <div class="mb-row mb-snippet-url">https://www.google.com/search</div>
        <div class="mb-row mb-snippet-description"><?php _e('Hello user, welcome to our site. Feel free to check our great offer for best prices.', 'all_in_one'); ?></div>
      </div>

      <div class="mb-row mb-snippet-preview mb-snippet-real">
        <div class="mb-row mb-snippet-title"><?php echo $snippet_title; ?></div>
        <div class="mb-row mb-snippet-url"><?php echo $snippet_url; ?></div>
        <div class="mb-row mb-snippet-description"><?php echo $snippet_description; ?></div>

        <div class="mb-snippet-yours"><i class="fa fa-angle-left"></i><span><?php _e('Your website', 'all_in_one'); ?></span></div>
      </div>

      <div class="mb-row mb-snippet-preview mb-snippet-fake">
        <div class="mb-row mb-snippet-title"><?php _e('OtherSite.com - Alabama local', 'all_in_one'); ?></div>
        <div class="mb-row mb-snippet-url">https://www.youtube.com/classifieds</div>
        <div class="mb-row mb-snippet-description"><?php _e('Are you looking to trade with videos? Do you want to sell or share them? You are on right place.', 'all_in_one'); ?></div>
      </div>
    </div>
  </div>



  

  <!-- PLUGIN INTEGRATION -->
  <div class="mb-box" <?php if( osc_get_preference('title_extra', 'plugin-ais') == 0 ) { ?>style="display:none;"<?php } ?> >
    <div class="mb-head"><i class="fa fa-wrench"></i> <?php _e('Plugin Setup', 'all_in_one'); ?></div>

    <div class="mb-inside">

      <div class="mb-row">
        <div class="mb-line"><?php _e('By default, <strong>Title</strong> and <strong>Meta Title</strong> are same. To apply different settings for them it is required to locate following code in your theme files', 'all_in_one'); ?>:</div>
        <span class="mb-code">&lt;title&gt;&lt;?php echo meta_title() ; ?&gt;&lt;/title&gt;</span>
        <div class="mb-line" style="margin-top:20px;"><?php _e('And replace it with', 'all_in_one'); ?>:</div>
        <span class="mb-code">&lt;title&gt;&lt;?php echo ais_title() ; ?&gt;&lt;/title&gt;</span>
        <div class="mb-line" style="margin-top:20px;"><?php _e('Usually this code is located in file head.php or common/head.php in your theme folder.', 'all_in_one'); ?></div>
      </div>
    </div>
  </div>



  <!-- HELP TOPICS -->
  <div class="mb-box" id="mb-help">
    <div class="mb-head"><i class="fa fa-question-circle"></i> <?php _e('Help', 'all_in_one'); ?></div>

    <div class="mb-inside">
      <div class="mb-row mb-help"><span class="sup">(3)</span> <div class="h3"><?php _e('It is recommended to use 1 character only, i.e. | or -. Do not enter white spaces.', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><span class="sup">(4)</span> <div class="h4"><?php _e('If you leave any of these fields empty, default settings will be used and website title & description will be shown.', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><span class="sup">(5)</span> <div class="h5"><?php _e('Nowadays meta keywords are not considered in SEO and there is no reason to keep them.', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><span class="sup">(6)</span> <div class="h6"><?php _e('If title, meta title or meta description tags generated by All in One SEO Plugin are empty, use default one generated by osclass to avoid showing empty tags.', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><span class="sup">(7)</span> <div class="h7"><?php _e('When enabled, you will be able to configure page title (shown in browser as title) differently to meta title (shown in google).', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><span class="sup">(8)</span> <div class="h8"><?php _e('If you have 2 or more active languages on your classifieds, language name will be added to Meta Title to avoid mark your sites as duplicated.', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><div><?php _e('Meta title should have 50-60 characters and Meta description 150-160 characters.', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><div><?php _e('If meta title or meta description is empty/blank, it is not shown in source code.', 'all_in_one'); ?></div></div>
      <div class="mb-row mb-help"><div><?php _e('Note that Google may not show your meta title or description, if it does not match to search or google can show better content!', 'all_in_one'); ?></div></div>
    </div>
  </div>
</div>

<?php echo ais_footer(); ?>
